<?php

use Illuminate\Support\Facades\Route;

use Illuminate\Support\Facades\Artisan;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::middleware('maintain')->group(function(){
    Route::get('/' , 'WebsiteController@index')->name('home');
    Route::get('/about' , 'WebsiteController@about')->name('about');
    Route::get('/blogs' , 'WebsiteController@blogs')->name('blogs');
    Route::get('/blogs/{slug}' , 'WebsiteController@show_blog')->name('show_blog');
    Route::get('/contact' , 'WebsiteController@contact')->name('contact');
    Route::get('/albums' , 'WebsiteController@albums')->name('albums');
    Route::get('/albums/{slug}' , 'WebsiteController@gallery')->name('show_album');
    Route::get('/services/{slug}' , 'WebsiteController@show_service')->name('show_service');
    Route::post('/message/send' , 'WebsiteController@contactMessage')->name('message.store');
});


Route::namespace('Dashboard')->prefix('vertex-admin')->name('admin.')->middleware('auth')->group(function()
{
    Route::resource('/' , 'StatisticController' , ['except' => ['create' , 'update' , 'destroy' , 'edit' ,'store' ,'show' ]]);

    Route::resource('/services' , 'ServiceController');
//    Route::get('/services/show/sub/{service}' , 'ServiceController@sub_show')->name('subservice.show');

    Route::resource('/images' , 'ImageController' , ['except' => ['create' ,'store' ]]);

    Route::resource('/videos' , 'VideoController' , ['except' => ['create' ,'store','show','index' ]]);

    Route::resource('/settings' , 'SettingController' , ['except' => ['create' , 'destroy' , 'store' ,'show' ]]);

    Route::resource('/contact' , 'ContactController' , ['except' => ['create' , 'destroy' , 'store' ,'show','index' ]]);

    Route::resource('/about' , 'AboutController' , ['except' => ['create' , 'destroy' , 'store' ,'show','index' ]]);

    Route::resource('/message' , 'MessageController' , ['except' => ['create','store','edit','update' ]]);

    Route::resource('/slider' , 'SliderController' );

    Route::resource('/blog' , 'BlogController');

    Route::resource('/testimonials' , 'CommentController');

    Route::resource('/albums' , 'AlbumController' );

    Route::resource('/projects' , 'ProjectController');

    Route::get('/album/upload/{album}/image-to-galary' , 'AlbumController@upload' )->name('album.upload.image');

    Route::post('/album/upload/{album}/image-to-galary' , 'AlbumController@store_image' )->name('album.store.image');

    Route::get('/album/add/{album}/video-to-galary' , 'AlbumController@upload' )->name('album.add.video');

    Route::post('/album/add/{album}/video-to-galary' , 'AlbumController@store_video' )->name('album.store.video');

});

Auth::routes();



/*--============ group less routs ============--*/

Route::get('/lang/{lang}' , 'SettingController@set_lang');
Route::get('/maintenance' , 'SettingController@active')->name('maintenance');
Route::post('/maintenance/message/send' , 'SettingController@contact')->name('maintenance.message.store');

Route::get('/clear', function() {
    Artisan::call('config:cache');
    Artisan::call('key:generate');
    Artisan::call('route:clear');
    Artisan::call('vendor:publish');
    Artisan::call('view:clear');
    Artisan::call('cache:clear');
    Artisan::call('config:clear');
    dd('done');
});
/*--============ end group less routs ============--*/