@extends('website.layouts.layout')

@section('title' , 'Gallery')


@section('content')
    <!--Page Title-->
    <section class="page-title" style="background-image:url({{asset('website/images/background/10.jpg')}});">
        <div class="auto-container">
            <div class="inner-container clearfix">
                <div class="title-box">
                    <h1>{{$album->{'album_'.currentLang()}->title }}</h1>
                </div>
                <ul class="bread-crumb clearfix">
                    <li><a href="{{route('home')}}">Home</a></li>
                    <li>{{$album->{'album_'.currentLang()}->title }}</li>
                </ul>
            </div>
        </div>
    </section>
    <!--End Page Title-->

    <!--Project Detail Section-->
    <section class="project-details-section">
        <div class="project-detail">
            <div class="auto-container">
                <!-- Upper Box -->
                <div class="upper-box">
                    <!--Project Tabs-->
                    <div class="project-tabs tabs-box clearfix">
                        <!--Tab Btns-->
                        <ul class="tab-btns tab-buttons clearfix">
                            @php $active = true; @endphp
                            @foreach($album->images as $image)
                            <li data-tab="{{'#tab-'.$image->id}}" class="tab-btn @if($active) active-btn @endif"><img src="{{asset($image->path)}}" alt=""></li>
                                @php $active = false; @endphp
                            @endforeach
                        </ul>


                        <!--Tabs Container-->
                        <div class="tabs-content">
                            <!--Tab / Active Tab-->
                            @php $active = true; @endphp
                            @foreach($album->images as $image)
                            <div class="tab @if($active) active-tab @endif" id="{{'tab-'.$image->id}}">
                                <figure class="image"><a href="{{asset($image->path)}}" class="lightbox-image" data-fancybox="images"><img src="{{asset($image->path)}}" alt=""></a></figure>
                            </div>
                                @php $active = false; @endphp
                            @endforeach
                        </div>
                    </div>
                </div>


            </div>
        </div>
    </section>
    <!--End Portfolio Details-->
@endsection