@extends('dashboard.layouts.layouts')

@section('title')
    testimonials
@endsection

@section('content')
    <section class="content-header">
        <h1>
            testimonials
            <small>All testimonials</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="{{adminUrl('/')}}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="{{route('admin.testimonials.index')}}">testimonials</a></li>
            <li class="active">All testimonials</li>
        </ol>
    </section>

    <div class="" style="width:95%; margin: auto; padding:20px;">
        @if(session()->has('created'))
            <div class="alert alert-success" style="" role="alert">
                {{ session()->get('created') }}
            </div>
        @endif

        @if(session()->has('updated'))
            <div class="alert alert-success" style="" role="alert">
                {{ session()->get('updated') }}
            </div>
        @endif

        @if(session()->has('deleted'))
            <div class="alert alert-danger" role="alert">
                {{ session()->get('deleted') }}
            </div>
        @endif
    </div>

    <section class="content">
        <div class="row">
            <!-- left column -->
            <div class="col-md-12">
                <div class="box box-primary" style="padding: 15px">
                    <div class="box-header with-border">
                        <h3 class="box-title">All testimonials Info</h3>
                        <a href="{{route('admin.testimonials.create')}}"
                           class="btn btn-primary pull-right"><i class="fa fa-plus"></i> Add New testimonial </a>
                    </div>
                    <!-- /.box-header -->
                    <!-- form start -->
                    <div id="example1_wrapper" class="dataTables_wrapper form-inline dt-bootstrap">
                        <div class="row">
                            <div class="col-sm-12">
                                <table id="example1" class="table table-bordered table-striped show-edit-category-table">
                                    <thead>
                                    <tr>
                                        <th>Id</th>
                                        <th>Image</th>
                                        <th>Name</th>
                                        <th>Job Title</th>
{{--                                        <th>testimonial</th>--}}
                                        <th>date</th>
                                        <th>Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($comments as $comment)
                                            <tr>
                                                <td>{{$comment->id}}</td>
                                                <td>
                                                    <div class="modal-btn" data-toggle="modal" data-target="#exampleModal">
                                                        <img style="width:50px;" src="{{asset($comment->image->path)}}"
                                                             alt="{{$comment->image->alt}}">
                                                    </div>
                                                </td>
                                                <td>{{$comment->comment_en->fullname}}</td>
                                                <td>{{$comment->comment_en->job_title}}</td>
{{--                                                <td>{{$comment->comment_en->comment}}</td>--}}
                                                <td>{{$comment->created_at->format('D M Y')}}</td>
                                                <td>
                                                    <a href="{{$comment->commentEdit()}}" class="" style="font-size: 20px"><i class="fa fa-pencil-square-o"></i> </a>
                                                    <button type="button" class="" data-toggle="modal" data-target="#{{'delete'.$comment->id}}" style="font-size: 20px">
                                                        <i class="fa fa-trash"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                    @endforeach
                                    </tbody>
                                </table>

                            </div>
                        </div>
                    </div>
                    @foreach($comments as $comment)
                        <div class="modal modal-danger fade" id="{{'delete'.$comment->id}}" style="display: none;">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">×</span></button>
                                        <h4 class="modal-title">Delete Image</h4>
                                    </div>
                                    <div class="modal-body">
                                        <p>Are You Sure You Want To Delete {{$comment->comment_en->fullname."'s"}} testimonial </p>
                                    </div>
                                    <div class="modal-footer">
                                        <form action="{{$comment->commentDelete()}}" method="post">
                                            @csrf
                                            @method('DELETE')
                                            <input type="hidden" name="_method" value="delete">
                                            <div class="d-flex flex-row">
                                                <button type="button" class="btn btn-outline-danger" data-dismiss="modal" style="margin-right: 5px">
                                                    cancel
                                                </button>
                                                <button type="submit" class="btn btn-danger">
                                                    Delete
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                                <!-- /.modal-content -->
                            </div>
                            <!-- /.modal-dialog -->
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </section>

@endsection('content')
