@extends('dashboard.layouts.layouts')

@section('title')
    update service
@endsection
@section('customizedScript')
    <script>
        $(function(){
            CKEDITOR.replace("description_en");
            CKEDITOR.replace("description_ar");

        })
    </script>
@endsection
@section('content')

    <section class="content-header">
        <h1>
            Service
            <small>Update</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="{{adminUrl('/')}}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="{{route('admin.services.index')}}">Service</a></li>
            <li class="active">Update Service</li>
        </ol>
    </section>

    @include('dashboard.layouts.messages')

    <section class="content">
        <form role="form" action="{{$service->serviceUpdate()}}" enctype="multipart/form-data" method="POST">
            @csrf
            @method('PUT')
            <div class="row">
                <!-- English Side -->
                <div class="col-md-6">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Update Service Info</h3>
                        </div>
                        <!-- /.box-header -->
                        <!-- form start -->
                        <div class="box-body">
                            <div class="form-group">
                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1"> Title</label>
                                    <input type="text"
                                           class="form-control"
                                           name="title_en"
                                           id="exampleInputEmail1"
                                           placeholder="Enter Service Title"
                                           value="{{$service->services_en->title}}">
                                    <p class="help-block">Enter title of service</p>

                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1">Service Url</label>
                                    <input type="text"
                                           class="form-control"
                                           name="url"
                                           id="exampleInputEmail1"
                                           placeholder="Enter Service slug"
                                           value="{{$service->url}}"
                                    >
                                    <p class="help-block">Enter Url of Article which will shown in url <strong>If Url is empty, system will choose article title as url by Default</strong></p>

                                </div>

                                <div class="col-lg-12">
                                    <label for="description_en"> Service Description</label>
                                    <textarea
                                            class=" form-control"
                                            name="description_en"
                                            id="description_en"
                                    >{{$service->services_en->description}}</textarea>
                                    <p class="help-block">Enter Description of Service</p>
                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1"> Image</label>
                                    <input
                                            type="file"
                                            class="form-control"
                                            name="image"
                                            id="exampleInputEmail1"
                                            placeholder="Enter Service text">
                                    <p class="help-block"> Upload Service Image </p>
                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1"> service album </label>
                                    <input type="file" class="form-control" name="images[]" multiple="" id="exampleInputEmail1" placeholder="Enter Service text">
                                    <p class="help-block"> Upload <strong>images</strong> for the service album</p>
                                </div>



                            </div>
                        </div>
                        <div class="box-footer">
                            <div class="col-lg-12">
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Arabic Side -->
                <div class="col-md-6 arab_dir">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">أضف بيانات الصورة</h3>
                        </div>
                        <!-- .box-header -->
                        <!-- form start -->
                        <div class="box-body">
                            <div class="form-group">

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1"> عنوان الخدمة</label>
                                    <input type="text"
                                           class="form-control"
                                           name="title_ar"
                                           id="editor10"
                                           style="text-align: right;"
                                           placeholder="ادخل عنوان الخدمة"
                                           value="{{$service->services_ar->title}}">
                                    <p class="help-block">أضف عنوان الخدمة</p>
                                </div>



                                <div class="col-lg-12">
                                    <label for="ardisc"> وصف الخدمة</label>
                                    <textarea class="form-control"
                                              name="description_ar"
                                              id="ardisc"
                                              style="text-align: right;"
                                    >{{$service->services_ar->description}}</textarea>
                                    <p class="help-block">ادخل وصفا دقيقا عن الخدمة</p>
                                </div>

                                {{--                            <div class="col-lg-12">--}}
                                {{--                                <label for="exampleInputEmail1">وصف الخدمة</label>--}}
                                {{--                                <textarea class="form-control" name="description_ar" --}}{{--id="editor12"--}}{{-- placeholder="ادخل  وصف الخدمة" rows="6" style="visibility: hidden; display: none;"></textarea><div id="cke_editor12" class="cke_2 cke cke_reset cke_chrome cke_editor_editor12 cke_ltr cke_browser_gecko" dir="ltr" role="application" aria-labelledby="cke_editor12_arialbl" lang="en"><span id="cke_editor12_arialbl" class="cke_voice_label">Rich Text Editor, editor12</span><div class="cke_inner cke_reset" role="presentation"><span id="cke_2_top" class="cke_top cke_reset_all" role="presentation" style="height: auto; user-select: none;"><span id="cke_59" class="cke_voice_label">Editor toolbars</span><span id="cke_2_toolbox" class="cke_toolbox" role="group" aria-labelledby="cke_59" onmousedown="return false;"><span id="cke_62" class="cke_toolbar" aria-labelledby="cke_62_label" role="toolbar"><span id="cke_62_label" class="cke_voice_label">Clipboard/Undo</span><span class="cke_toolbar_start"></span><span class="cke_toolgroup" role="presentation"><a id="cke_63" class="cke_button cke_button__cut cke_button_disabled " title="Cut" tabindex="-1" hidefocus="true" role="button" aria-labelledby="cke_63_label" aria-haspopup="false" aria-disabled="true" onblur="this.style.cssText = this.style.cssText;" onkeydown="return CKEDITOR.tools.callFunction(93,event);" onfocus="return CKEDITOR.tools.callFunction(94,event);" onclick="CKEDITOR.tools.callFunction(95,this);return false;"><span class="cke_button_icon cke_button__cut_icon" style="background-image:url(https://cdn.ckeditor.com/4.4.3/standard/plugins/icons.png?t=E6FD);background-position:0 -264px;background-size:auto;">&nbsp;</span><span id="cke_63_label" class="cke_button_label cke_button__cut_label" aria-hidden="false">Cut</span></a><a id="cke_64" class="cke_button cke_button__copy cke_button_disabled " title="Copy" tabindex="-1" hidefocus="true" role="button" aria-labelledby="cke_64_label" aria-haspopup="false" aria-disabled="true" onblur="this.style.cssText = this.style.cssText;" onkeydown="return CKEDITOR.tools.callFunction(96,event);" onfocus="return CKEDITOR.tools.callFunction(97,event);" onclick="CKEDITOR.tools.callFunction(98,this);return false;"><span class="cke_button_icon cke_button__copy_icon" style="background-image:url(https://cdn.ckeditor.com/4.4.3/standard/plugins/icons.png?t=E6FD);background-position:0 -216px;background-size:auto;">&nbsp;</span><span id="cke_64_label" class="cke_button_label cke_button__copy_label" aria-hidden="false">Copy</span></a><a id="cke_65" class="cke_button cke_button__paste  cke_button_off" title="Paste" tabindex="-1" hidefocus="true" role="button" aria-labelledby="cke_65_label" aria-haspopup="false" onblur="this.style.cssText = this.style.cssText;" onkeydown="return CKEDITOR.tools.callFunction(99,event);" onfocus="return CKEDITOR.tools.callFunction(100,event);" onclick="CKEDITOR.tools.callFunction(101,this);return false;"><span class="cke_button_icon cke_button__paste_icon" style="background-image:url(https://cdn.ckeditor.com/4.4.3/standard/plugins/icons.png?t=E6FD);background-position:0 -312px;background-size:auto;">&nbsp;</span><span id="cke_65_label" class="cke_button_label cke_button__paste_label" aria-hidden="false">Paste</span></a><a id="cke_66" class="cke_button cke_button__pastetext  cke_button_off" title="Paste as plain text" tabindex="-1" hidefocus="true" role="button" aria-labelledby="cke_66_label" aria-haspopup="false" onblur="this.style.cssText = this.style.cssText;" onkeydown="return CKEDITOR.tools.callFunction(102,event);" onfocus="return CKEDITOR.tools.callFunction(103,event);" onclick="CKEDITOR.tools.callFunction(104,this);return false;"><span class="cke_button_icon cke_button__pastetext_icon" style="background-image:url(https://cdn.ckeditor.com/4.4.3/standard/plugins/icons.png?t=E6FD);background-position:0 -720px;background-size:auto;">&nbsp;</span><span id="cke_66_label" class="cke_button_label cke_button__pastetext_label" aria-hidden="false">Paste as plain text</span></a><a id="cke_67" class="cke_button cke_button__pastefromword  cke_button_off" title="Paste from Word" tabindex="-1" hidefocus="true" role="button" aria-labelledby="cke_67_label" aria-haspopup="false" onblur="this.style.cssText = this.style.cssText;" onkeydown="return CKEDITOR.tools.callFunction(105,event);" onfocus="return CKEDITOR.tools.callFunction(106,event);" onclick="CKEDITOR.tools.callFunction(107,this);return false;"><span class="cke_button_icon cke_button__pastefromword_icon" style="background-image:url(https://cdn.ckeditor.com/4.4.3/standard/plugins/icons.png?t=E6FD);background-position:0 -768px;background-size:auto;">&nbsp;</span><span id="cke_67_label" class="cke_button_label cke_button__pastefromword_label" aria-hidden="false">Paste from Word</span></a><span class="cke_toolbar_separator" role="separator"></span><a id="cke_68" class="cke_button cke_button__undo cke_button_disabled " title="Undo" tabindex="-1" hidefocus="true" role="button" aria-labelledby="cke_68_label" aria-haspopup="false" aria-disabled="true" onblur="this.style.cssText = this.style.cssText;" onkeydown="return CKEDITOR.tools.callFunction(108,event);" onfocus="return CKEDITOR.tools.callFunction(109,event);" onclick="CKEDITOR.tools.callFunction(110,this);return false;"><span class="cke_button_icon cke_button__undo_icon" style="background-image:url(https://cdn.ckeditor.com/4.4.3/standard/plugins/icons.png?t=E6FD);background-position:0 -1008px;background-size:auto;">&nbsp;</span><span id="cke_68_label" class="cke_button_label cke_button__undo_label" aria-hidden="false">Undo</span></a><a id="cke_69" class="cke_button cke_button__redo cke_button_disabled " title="Redo" tabindex="-1" hidefocus="true" role="button" aria-labelledby="cke_69_label" aria-haspopup="false" aria-disabled="true" onblur="this.style.cssText = this.style.cssText;" onkeydown="return CKEDITOR.tools.callFunction(111,event);" onfocus="return CKEDITOR.tools.callFunction(112,event);" onclick="CKEDITOR.tools.callFunction(113,this);return false;"><span class="cke_button_icon cke_button__redo_icon" style="background-image:url(https://cdn.ckeditor.com/4.4.3/standard/plugins/icons.png?t=E6FD);background-position:0 -960px;background-size:auto;">&nbsp;</span><span id="cke_69_label" class="cke_button_label cke_button__redo_label" aria-hidden="false">Redo</span></a></span><span class="cke_toolbar_end"></span></span><span id="cke_70" class="cke_toolbar" aria-labelledby="cke_70_label" role="toolbar"><span id="cke_70_label" class="cke_voice_label">Editing</span><span class="cke_toolbar_start"></span><span class="cke_toolgroup" role="presentation"><a id="cke_71" class="cke_button cke_button__scayt cke_button_off " title="" tabindex="-1" hidefocus="true" role="button" aria-labelledby="cke_71_label" aria-haspopup="true" onblur="this.style.cssText = this.style.cssText;" onkeydown="return CKEDITOR.tools.callFunction(114,event);" onfocus="return CKEDITOR.tools.callFunction(115,event);" onclick="CKEDITOR.tools.callFunction(116,this);return false;"><span class="cke_button_icon cke_button__scayt_icon" style="background-image:url(https://cdn.ckeditor.com/4.4.3/standard/plugins/icons.png?t=E6FD);background-position:0 -888px;background-size:auto;">&nbsp;</span><span id="cke_71_label" class="cke_button_label cke_button__scayt_label" aria-hidden="false"></span><span class="cke_button_arrow"></span></a></span><span class="cke_toolbar_end"></span></span><span id="cke_72" class="cke_toolbar" aria-labelledby="cke_72_label" role="toolbar"><span id="cke_72_label" class="cke_voice_label">Links</span><span class="cke_toolbar_start"></span><span class="cke_toolgroup" role="presentation"><a id="cke_73" class="cke_button cke_button__link  cke_button_off" title="Link" tabindex="-1" hidefocus="true" role="button" aria-labelledby="cke_73_label" aria-haspopup="false" onblur="this.style.cssText = this.style.cssText;" onkeydown="return CKEDITOR.tools.callFunction(117,event);" onfocus="return CKEDITOR.tools.callFunction(118,event);" onclick="CKEDITOR.tools.callFunction(119,this);return false;"><span class="cke_button_icon cke_button__link_icon" style="background-image:url(https://cdn.ckeditor.com/4.4.3/standard/plugins/icons.png?t=E6FD);background-position:0 -528px;background-size:auto;">&nbsp;</span><span id="cke_73_label" class="cke_button_label cke_button__link_label" aria-hidden="false">Link</span></a><a id="cke_74" class="cke_button cke_button__unlink cke_button_disabled " title="Unlink" tabindex="-1" hidefocus="true" role="button" aria-labelledby="cke_74_label" aria-haspopup="false" aria-disabled="true" onblur="this.style.cssText = this.style.cssText;" onkeydown="return CKEDITOR.tools.callFunction(120,event);" onfocus="return CKEDITOR.tools.callFunction(121,event);" onclick="CKEDITOR.tools.callFunction(122,this);return false;"><span class="cke_button_icon cke_button__unlink_icon" style="background-image:url(https://cdn.ckeditor.com/4.4.3/standard/plugins/icons.png?t=E6FD);background-position:0 -552px;background-size:auto;">&nbsp;</span><span id="cke_74_label" class="cke_button_label cke_button__unlink_label" aria-hidden="false">Unlink</span></a><a id="cke_75" class="cke_button cke_button__anchor  cke_button_off" title="Anchor" tabindex="-1" hidefocus="true" role="button" aria-labelledby="cke_75_label" aria-haspopup="false" onblur="this.style.cssText = this.style.cssText;" onkeydown="return CKEDITOR.tools.callFunction(123,event);" onfocus="return CKEDITOR.tools.callFunction(124,event);" onclick="CKEDITOR.tools.callFunction(125,this);return false;"><span class="cke_button_icon cke_button__anchor_icon" style="background-image:url(https://cdn.ckeditor.com/4.4.3/standard/plugins/icons.png?t=E6FD);background-position:0 -504px;background-size:auto;">&nbsp;</span><span id="cke_75_label" class="cke_button_label cke_button__anchor_label" aria-hidden="false">Anchor</span></a></span><span class="cke_toolbar_end"></span></span><span id="cke_76" class="cke_toolbar" aria-labelledby="cke_76_label" role="toolbar"><span id="cke_76_label" class="cke_voice_label">Insert</span><span class="cke_toolbar_start"></span><span class="cke_toolgroup" role="presentation"><a id="cke_77" class="cke_button cke_button__image  cke_button_off" title="Image" tabindex="-1" hidefocus="true" role="button" aria-labelledby="cke_77_label" aria-haspopup="false" onblur="this.style.cssText = this.style.cssText;" onkeydown="return CKEDITOR.tools.callFunction(126,event);" onfocus="return CKEDITOR.tools.callFunction(127,event);" onclick="CKEDITOR.tools.callFunction(128,this);return false;"><span class="cke_button_icon cke_button__image_icon" style="background-image:url(https://cdn.ckeditor.com/4.4.3/standard/plugins/icons.png?t=E6FD);background-position:0 -360px;background-size:auto;">&nbsp;</span><span id="cke_77_label" class="cke_button_label cke_button__image_label" aria-hidden="false">Image</span></a><a id="cke_78" class="cke_button cke_button__table  cke_button_off" title="Table" tabindex="-1" hidefocus="true" role="button" aria-labelledby="cke_78_label" aria-haspopup="false" onblur="this.style.cssText = this.style.cssText;" onkeydown="return CKEDITOR.tools.callFunction(129,event);" onfocus="return CKEDITOR.tools.callFunction(130,event);" onclick="CKEDITOR.tools.callFunction(131,this);return false;"><span class="cke_button_icon cke_button__table_icon" style="background-image:url(https://cdn.ckeditor.com/4.4.3/standard/plugins/icons.png?t=E6FD);background-position:0 -912px;background-size:auto;">&nbsp;</span><span id="cke_78_label" class="cke_button_label cke_button__table_label" aria-hidden="false">Table</span></a><a id="cke_79" class="cke_button cke_button__horizontalrule  cke_button_off" title="Insert Horizontal Line" tabindex="-1" hidefocus="true" role="button" aria-labelledby="cke_79_label" aria-haspopup="false" onblur="this.style.cssText = this.style.cssText;" onkeydown="return CKEDITOR.tools.callFunction(132,event);" onfocus="return CKEDITOR.tools.callFunction(133,event);" onclick="CKEDITOR.tools.callFunction(134,this);return false;"><span class="cke_button_icon cke_button__horizontalrule_icon" style="background-image:url(https://cdn.ckeditor.com/4.4.3/standard/plugins/icons.png?t=E6FD);background-position:0 -336px;background-size:auto;">&nbsp;</span><span id="cke_79_label" class="cke_button_label cke_button__horizontalrule_label" aria-hidden="false">Insert Horizontal Line</span></a><a id="cke_80" class="cke_button cke_button__specialchar  cke_button_off" title="Insert Special Character" tabindex="-1" hidefocus="true" role="button" aria-labelledby="cke_80_label" aria-haspopup="false" onblur="this.style.cssText = this.style.cssText;" onkeydown="return CKEDITOR.tools.callFunction(135,event);" onfocus="return CKEDITOR.tools.callFunction(136,event);" onclick="CKEDITOR.tools.callFunction(137,this);return false;"><span class="cke_button_icon cke_button__specialchar_icon" style="background-image:url(https://cdn.ckeditor.com/4.4.3/standard/plugins/icons.png?t=E6FD);background-position:0 -864px;background-size:auto;">&nbsp;</span><span id="cke_80_label" class="cke_button_label cke_button__specialchar_label" aria-hidden="false">Insert Special Character</span></a></span><span class="cke_toolbar_end"></span></span><span id="cke_81" class="cke_toolbar" aria-labelledby="cke_81_label" role="toolbar"><span id="cke_81_label" class="cke_voice_label">Tools</span><span class="cke_toolbar_start"></span><span class="cke_toolgroup" role="presentation"><a id="cke_82" class="cke_button cke_button__maximize  cke_button_off" title="Maximize" tabindex="-1" hidefocus="true" role="button" aria-labelledby="cke_82_label" aria-haspopup="false" onblur="this.style.cssText = this.style.cssText;" onkeydown="return CKEDITOR.tools.callFunction(138,event);" onfocus="return CKEDITOR.tools.callFunction(139,event);" onclick="CKEDITOR.tools.callFunction(140,this);return false;"><span class="cke_button_icon cke_button__maximize_icon" style="background-image:url(https://cdn.ckeditor.com/4.4.3/standard/plugins/icons.png?t=E6FD);background-position:0 -672px;background-size:auto;">&nbsp;</span><span id="cke_82_label" class="cke_button_label cke_button__maximize_label" aria-hidden="false">Maximize</span></a></span><span class="cke_toolbar_end"></span></span><span id="cke_83" class="cke_toolbar" aria-labelledby="cke_83_label" role="toolbar"><span id="cke_83_label" class="cke_voice_label">Document</span><span class="cke_toolbar_start"></span><span class="cke_toolgroup" role="presentation"><a id="cke_84" class="cke_button cke_button__source  cke_button_off" title="Source" tabindex="-1" hidefocus="true" role="button" aria-labelledby="cke_84_label" aria-haspopup="false" onblur="this.style.cssText = this.style.cssText;" onkeydown="return CKEDITOR.tools.callFunction(141,event);" onfocus="return CKEDITOR.tools.callFunction(142,event);" onclick="CKEDITOR.tools.callFunction(143,this);return false;"><span class="cke_button_icon cke_button__source_icon" style="background-image:url(https://cdn.ckeditor.com/4.4.3/standard/plugins/icons.png?t=E6FD);background-position:0 -840px;background-size:auto;">&nbsp;</span><span id="cke_84_label" class="cke_button_label cke_button__source_label" aria-hidden="false">Source</span></a></span><span class="cke_toolbar_end"></span></span><span class="cke_toolbar_break"></span><span id="cke_85" class="cke_toolbar" aria-labelledby="cke_85_label" role="toolbar"><span id="cke_85_label" class="cke_voice_label">Basic Styles</span><span class="cke_toolbar_start"></span><span class="cke_toolgroup" role="presentation"><a id="cke_86" class="cke_button cke_button__bold  cke_button_off" title="Bold" tabindex="-1" hidefocus="true" role="button" aria-labelledby="cke_86_label" aria-haspopup="false" onblur="this.style.cssText = this.style.cssText;" onkeydown="return CKEDITOR.tools.callFunction(144,event);" onfocus="return CKEDITOR.tools.callFunction(145,event);" onclick="CKEDITOR.tools.callFunction(146,this);return false;"><span class="cke_button_icon cke_button__bold_icon" style="background-image:url(https://cdn.ckeditor.com/4.4.3/standard/plugins/icons.png?t=E6FD);background-position:0 -24px;background-size:auto;">&nbsp;</span><span id="cke_86_label" class="cke_button_label cke_button__bold_label" aria-hidden="false">Bold</span></a><a id="cke_87" class="cke_button cke_button__italic  cke_button_off" title="Italic" tabindex="-1" hidefocus="true" role="button" aria-labelledby="cke_87_label" aria-haspopup="false" onblur="this.style.cssText = this.style.cssText;" onkeydown="return CKEDITOR.tools.callFunction(147,event);" onfocus="return CKEDITOR.tools.callFunction(148,event);" onclick="CKEDITOR.tools.callFunction(149,this);return false;"><span class="cke_button_icon cke_button__italic_icon" style="background-image:url(https://cdn.ckeditor.com/4.4.3/standard/plugins/icons.png?t=E6FD);background-position:0 -48px;background-size:auto;">&nbsp;</span><span id="cke_87_label" class="cke_button_label cke_button__italic_label" aria-hidden="false">Italic</span></a><a id="cke_88" class="cke_button cke_button__strike  cke_button_off" title="Strike Through" tabindex="-1" hidefocus="true" role="button" aria-labelledby="cke_88_label" aria-haspopup="false" onblur="this.style.cssText = this.style.cssText;" onkeydown="return CKEDITOR.tools.callFunction(150,event);" onfocus="return CKEDITOR.tools.callFunction(151,event);" onclick="CKEDITOR.tools.callFunction(152,this);return false;"><span class="cke_button_icon cke_button__strike_icon" style="background-image:url(https://cdn.ckeditor.com/4.4.3/standard/plugins/icons.png?t=E6FD);background-position:0 -72px;background-size:auto;">&nbsp;</span><span id="cke_88_label" class="cke_button_label cke_button__strike_label" aria-hidden="false">Strike Through</span></a><span class="cke_toolbar_separator" role="separator"></span><a id="cke_89" class="cke_button cke_button__removeformat  cke_button_off" title="Remove Format" tabindex="-1" hidefocus="true" role="button" aria-labelledby="cke_89_label" aria-haspopup="false" onblur="this.style.cssText = this.style.cssText;" onkeydown="return CKEDITOR.tools.callFunction(153,event);" onfocus="return CKEDITOR.tools.callFunction(154,event);" onclick="CKEDITOR.tools.callFunction(155,this);return false;"><span class="cke_button_icon cke_button__removeformat_icon" style="background-image:url(https://cdn.ckeditor.com/4.4.3/standard/plugins/icons.png?t=E6FD);background-position:0 -792px;background-size:auto;">&nbsp;</span><span id="cke_89_label" class="cke_button_label cke_button__removeformat_label" aria-hidden="false">Remove Format</span></a></span><span class="cke_toolbar_end"></span></span><span id="cke_90" class="cke_toolbar" aria-labelledby="cke_90_label" role="toolbar"><span id="cke_90_label" class="cke_voice_label">Paragraph</span><span class="cke_toolbar_start"></span><span class="cke_toolgroup" role="presentation"><a id="cke_91" class="cke_button cke_button__numberedlist  cke_button_off" title="Insert/Remove Numbered List" tabindex="-1" hidefocus="true" role="button" aria-labelledby="cke_91_label" aria-haspopup="false" onblur="this.style.cssText = this.style.cssText;" onkeydown="return CKEDITOR.tools.callFunction(156,event);" onfocus="return CKEDITOR.tools.callFunction(157,event);" onclick="CKEDITOR.tools.callFunction(158,this);return false;"><span class="cke_button_icon cke_button__numberedlist_icon" style="background-image:url(https://cdn.ckeditor.com/4.4.3/standard/plugins/icons.png?t=E6FD);background-position:0 -648px;background-size:auto;">&nbsp;</span><span id="cke_91_label" class="cke_button_label cke_button__numberedlist_label" aria-hidden="false">Insert/Remove Numbered List</span></a><a id="cke_92" class="cke_button cke_button__bulletedlist  cke_button_off" title="Insert/Remove Bulleted List" tabindex="-1" hidefocus="true" role="button" aria-labelledby="cke_92_label" aria-haspopup="false" onblur="this.style.cssText = this.style.cssText;" onkeydown="return CKEDITOR.tools.callFunction(159,event);" onfocus="return CKEDITOR.tools.callFunction(160,event);" onclick="CKEDITOR.tools.callFunction(161,this);return false;"><span class="cke_button_icon cke_button__bulletedlist_icon" style="background-image:url(https://cdn.ckeditor.com/4.4.3/standard/plugins/icons.png?t=E6FD);background-position:0 -600px;background-size:auto;">&nbsp;</span><span id="cke_92_label" class="cke_button_label cke_button__bulletedlist_label" aria-hidden="false">Insert/Remove Bulleted List</span></a><span class="cke_toolbar_separator" role="separator"></span><a id="cke_93" class="cke_button cke_button__outdent cke_button_disabled " title="Decrease Indent" tabindex="-1" hidefocus="true" role="button" aria-labelledby="cke_93_label" aria-haspopup="false" aria-disabled="true" onblur="this.style.cssText = this.style.cssText;" onkeydown="return CKEDITOR.tools.callFunction(162,event);" onfocus="return CKEDITOR.tools.callFunction(163,event);" onclick="CKEDITOR.tools.callFunction(164,this);return false;"><span class="cke_button_icon cke_button__outdent_icon" style="background-image:url(https://cdn.ckeditor.com/4.4.3/standard/plugins/icons.png?t=E6FD);background-position:0 -456px;background-size:auto;">&nbsp;</span><span id="cke_93_label" class="cke_button_label cke_button__outdent_label" aria-hidden="false">Decrease Indent</span></a><a id="cke_94" class="cke_button cke_button__indent  cke_button_off" title="Increase Indent" tabindex="-1" hidefocus="true" role="button" aria-labelledby="cke_94_label" aria-haspopup="false" onblur="this.style.cssText = this.style.cssText;" onkeydown="return CKEDITOR.tools.callFunction(165,event);" onfocus="return CKEDITOR.tools.callFunction(166,event);" onclick="CKEDITOR.tools.callFunction(167,this);return false;"><span class="cke_button_icon cke_button__indent_icon" style="background-image:url(https://cdn.ckeditor.com/4.4.3/standard/plugins/icons.png?t=E6FD);background-position:0 -408px;background-size:auto;">&nbsp;</span><span id="cke_94_label" class="cke_button_label cke_button__indent_label" aria-hidden="false">Increase Indent</span></a><span class="cke_toolbar_separator" role="separator"></span><a id="cke_95" class="cke_button cke_button__blockquote  cke_button_off" title="Block Quote" tabindex="-1" hidefocus="true" role="button" aria-labelledby="cke_95_label" aria-haspopup="false" onblur="this.style.cssText = this.style.cssText;" onkeydown="return CKEDITOR.tools.callFunction(168,event);" onfocus="return CKEDITOR.tools.callFunction(169,event);" onclick="CKEDITOR.tools.callFunction(170,this);return false;"><span class="cke_button_icon cke_button__blockquote_icon" style="background-image:url(https://cdn.ckeditor.com/4.4.3/standard/plugins/icons.png?t=E6FD);background-position:0 -168px;background-size:auto;">&nbsp;</span><span id="cke_95_label" class="cke_button_label cke_button__blockquote_label" aria-hidden="false">Block Quote</span></a></span><span class="cke_toolbar_end"></span></span><span id="cke_96" class="cke_toolbar" aria-labelledby="cke_96_label" role="toolbar"><span id="cke_96_label" class="cke_voice_label">Styles</span><span class="cke_toolbar_start"></span><span id="cke_60" class="cke_combo cke_combo__styles  cke_combo_off" role="presentation"><span id="cke_60_label" class="cke_combo_label">Styles</span><a class="cke_combo_button" hidefocus="true" title="Formatting Styles" tabindex="-1" role="button" aria-labelledby="cke_60_label" aria-haspopup="true" onblur="this.style.cssText = this.style.cssText;" onkeydown="return CKEDITOR.tools.callFunction(172,event,this);" onfocus="return CKEDITOR.tools.callFunction(173,event);" onclick="CKEDITOR.tools.callFunction(171,this);return false;"><span id="cke_60_text" class="cke_combo_text cke_combo_inlinelabel">Styles</span><span class="cke_combo_open"><span class="cke_combo_arrow"></span></span></a></span><span id="cke_61" class="cke_combo cke_combo__format  cke_combo_off" role="presentation"><span id="cke_61_label" class="cke_combo_label">Format</span><a class="cke_combo_button" hidefocus="true" title="Paragraph Format" tabindex="-1" role="button" aria-labelledby="cke_61_label" aria-haspopup="true" onblur="this.style.cssText = this.style.cssText;" onkeydown="return CKEDITOR.tools.callFunction(175,event,this);" onfocus="return CKEDITOR.tools.callFunction(176,event);" onclick="CKEDITOR.tools.callFunction(174,this);return false;"><span id="cke_61_text" class="cke_combo_text cke_combo_inlinelabel">Format</span><span class="cke_combo_open"><span class="cke_combo_arrow"></span></span></a></span><span class="cke_toolbar_end"></span></span><span id="cke_97" class="cke_toolbar" aria-labelledby="cke_97_label" role="toolbar"><span id="cke_97_label" class="cke_voice_label">about</span><span class="cke_toolbar_start"></span><span class="cke_toolgroup" role="presentation"><a id="cke_98" class="cke_button cke_button__about  cke_button_off" title="About CKEditor" tabindex="-1" hidefocus="true" role="button" aria-labelledby="cke_98_label" aria-haspopup="false" onblur="this.style.cssText = this.style.cssText;" onkeydown="return CKEDITOR.tools.callFunction(177,event);" onfocus="return CKEDITOR.tools.callFunction(178,event);" onclick="CKEDITOR.tools.callFunction(179,this);return false;"><span class="cke_button_icon cke_button__about_icon" style="background-image:url(https://cdn.ckeditor.com/4.4.3/standard/plugins/icons.png?t=E6FD);background-position:0 0px;background-size:auto;">&nbsp;</span><span id="cke_98_label" class="cke_button_label cke_button__about_label" aria-hidden="false">About CKEditor</span></a></span><span class="cke_toolbar_end"></span></span></span></span><div id="cke_2_contents" class="cke_contents cke_reset" role="presentation" style="height: 200px;"><span id="cke_103" class="cke_voice_label">Press ALT 0 for help</span><iframe src="" style="width: 100%; height: 100%;" class="cke_wysiwyg_frame cke_reset" title="Rich Text Editor, editor12" aria-describedby="cke_103" tabindex="0" allowtransparency="true" frameborder="0"></iframe></div><span id="cke_2_bottom" class="cke_bottom cke_reset_all" role="presentation" style="user-select: none;"><span id="cke_2_resizer" class="cke_resizer cke_resizer_vertical cke_resizer_rtl" title="Resize" onmousedown="CKEDITOR.tools.callFunction(91, event)">◣</span><span id="cke_2_path_label" class="cke_voice_label">Elements path</span><span id="cke_2_path" class="cke_path" role="group" aria-labelledby="cke_2_path_label"><span class="cke_path_empty">&nbsp;</span></span></span></div></div>--}}
                                {{--                                <p class="help-block">ادخل وصفا دقيقا عن الخدمة</p>--}}
                                {{--                            </div>--}}



                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </section>

@endsection('content')