<?php

namespace App\Models;

use App\Models\Resource\Image;
use App\User;
use Illuminate\Database\Eloquent\Model;

class Slider extends Model
{
    protected $table = 'slider';

   protected $fillable = ['image_id','btn_url' , 'created_by' , 'user_id'];

    /*---------eloquent-relationships----------------*/
    public function slider_en(){
       return $this->hasOne(\App\Models\English\Slider::class , 'slide_id' , 'id');
    }

    public function slider_ar(){
      return $this->hasOne(\App\Models\Arabic\Slider::class , 'slide_id' , 'id');
    }

    public function image(){
        return $this->belongsTo(Image::class ,   'image_id' , 'id');
    }

    public function user(){
        return $this->belongsTo(User::class , 'user_id' , 'id');
    }

    public function childSlider() {
        return $this->hasMany( Slider::class , 'parent_slider_id' , 'id');
    }
    /*--------end-eloquent-relationships------------*/

    /*---------route-functions----------------------*/

    public function show_sub(){
        return route('admin.slider.show' , $this->id);
    }

    public function slideEdit(){
        return route('admin.slider.edit' , $this->id);
    }

    public function slideUpdate(){
        return route('admin.slider.update' , $this->id);
    }

    public function slideDelete(){
        return route('admin.slider.destroy' , $this->id);
    }

    public function createSubSlider(){
        $slider = $this->id;
        return route('admin.slider.create' , compact('slider'));
    }
    /*---------end-route-functions------------------*/
}
