<?php

namespace App\Models;

use App\Models\Resource\Image;
use Illuminate\Database\Eloquent\Model;

class Comment extends Model
{
    /*========over=riding==========*/
    protected $connection = 'mysql';
    protected $table = 'comments';
    /*=======end=over=riding==========*/

    /*============eloquent=relationships=================*/

    public function image(){
        return $this->belongsTo(Image::class , 'img' , 'id');
    }

    public function comment_en(){
        return $this->hasOne(\App\Models\English\Comment::class , 'comment_id' , 'id');
    }

    public function comment_ar(){
        return $this->hasOne( \App\Models\Arabic\Comment::class , 'comment_id' , 'id');
    }
    /*===========end=eloquent=relationships==============*/


    /*===============rout=methods=======================*/

    public function commentEdit(){
        return route('admin.testimonials.edit' , $this->id);
    }

    public function commentUpdate(){
      return route('admin.testimonials.update' , $this->id);
    }

    public function commentDelete(){
        return route('admin.testimonials.destroy' , $this->id);
    }
    /*===============end=route=methods=================*/

}
