<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Setting;
use Illuminate\Support\Facades\File;
use App\Models\Resource\Image;

class SettingController extends Controller
{
   public function  edit(Setting $setting){

      return view('dashboard.setting.edit' , compact('setting'));
   }

   public function update(Setting $setting , Request $request ){

       $oldImgId = $setting->headerLogo;


       if ($request->hasFile('h_logo')) {

           $uploadedFile = $request->file('h_logo');
           $fileName = time() . $uploadedFile->getClientOriginalName();
           $uploadedFile->move('dashboardImages/images', $fileName);
           $filePath = 'dashboardImages/images/' . $fileName;

           $img = new Image();
           $img->path = $filePath;
           $img->name = $fileName;
           $img->alt = 'empty';
           $img->save();
       }

       if($request->hasFile('h_logo')){
           $setting->h_logo_id = $img->id;
       }

//       $setting->h_logo_id = $image->id;
       $setting->name_en = $request['website_name_en'];
       $setting->name_ar = $request['website_name_ar'];
       $setting->description_en = $request['website_description_en'];
       $setting->description_ar = $request['website_description_ar'];
       $setting->active = $request['status'];
       $setting->lang = $request['default_lang'];
       $setting->update();


       if($request->hasFile('h_logo') && $oldImgId){
           $oldImgId->delete();
           File::delete($oldImgId->path);
       }

       return redirect()->route('admin.settings.edit' , $setting->id)->with('updated' , 'website settings has been updated successfully!');
   }
}
