<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Models\Project;
use App\Models\Resource\Image;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class ProjectController extends Controller
{
    public function index(){
        $projects = Project::orderBy('projects.created_at' , 'desc')->with('beforeImage' , 'afterImage')->get();
        return view('dashboard.project.index' , compact('projects'));
    }

    public function create(){
        return view('dashboard.project.create');
    }

    public function store(Request $request){
        $request->validate([
            'before_image' => 'required|mimes:jpg,jpeg,bmp,png|max:10240',
            'after_image' => 'required|mimes:jpg,jpeg,bmp,png|max:10240'
        ]);

        if ($request->hasFile('before_image')) {
            $uploadedFile = $request->file('before_image');
            $fileName = time() . $uploadedFile->getClientOriginalName();
            $uploadedFile->move('dashboardImages/images', $fileName);
            $filePath = 'dashboardImages/images/' . $fileName;
            $beforeImage = new Image();
            $beforeImage->path = $filePath ;
            $beforeImage->name = $fileName;
            $beforeImage->alt = 'this is an image' ;
            $beforeImage->save();
        }

        if ($request->hasFile('after_image')) {
            $uploadedFile = $request->file('after_image');
            $fileName = time() . $uploadedFile->getClientOriginalName();
            $uploadedFile->move('dashboardImages/images', $fileName);
            $filePath = 'dashboardImages/images/' . $fileName;
            $afterImage = new Image();
            $afterImage->path = $filePath ;
            $afterImage->name = $fileName;
            $afterImage->alt  = 'this is an image';
            $afterImage->save();
        }

        $project = new Project();

        $project->description = $request['description'];

        if ($request->hasFile('before_image')) {
            $project->before_img_id = $beforeImage->id ;
        }

        if ($request->hasFile('after_image')) {
            $project->after_img_id = $afterImage->id ;
        }

       $project->save();

       return redirect()->route('admin.projects.index')->with('created' , 'before&after project images created successfully!!');
    }

    public function edit(Project $project){
       return view('dashboard.project.edit' , compact('project'));
    }

    public function update(Request $request , Project $project){

        $request->validate([
            'before_image' => 'mimes:jpg,jpeg,bmp,png|max:10240',
            'after_image' => 'mimes:jpg,jpeg,bmp,png|max:10240'
        ]);

        $oldBeforeImg = $project->beforeImage;
        $oldAfterImg =  $project->afterImage;


        if ($request->hasFile('before_image')) {
            $uploadedFile = $request->file('before_image');
            $fileName = time() . $uploadedFile->getClientOriginalName();
            $uploadedFile->move('dashboardImages/images', $fileName);
            $filePath = 'dashboardImages/images/' . $fileName;
            $beforeImage = new Image();
            $beforeImage->path = $filePath ;
            $beforeImage->name = $fileName;
            $beforeImage->alt = 'this is an image' ;
            $beforeImage->save();
        }

        if ($request->hasFile('after_image')) {
            $uploadedFile = $request->file('after_image');
            $fileName = time() . $uploadedFile->getClientOriginalName();
            $uploadedFile->move('dashboardImages/images', $fileName);
            $filePath = 'dashboardImages/images/' . $fileName;
            $afterImage = new Image();
            $afterImage->path = $filePath ;
            $afterImage->name = $fileName;
            $afterImage->alt  = 'this is an image';
            $afterImage->save();
        }

        $project->description = $request['description'];

        if ($request->hasFile('before_image')) {
            $project->before_img_id = $beforeImage->id ;
        }

        if ($request->hasFile('after_image')) {
            $project->after_img_id = $afterImage->id ;
        }

        $project->update();

        if($request->hasFile('before_image') && $oldBeforeImg){
            $oldBeforeImg->delete();
            File::delete($oldBeforeImg->path);
        }

        if ($request->hasFile('after_image') && $oldAfterImg){
            $oldAfterImg->delete();
            File::delete($oldAfterImg->path);
        }

        return redirect()->route('admin.projects.index')->with('updated' , 'before&after project images updated successfully!!');



    }

    public function destroy(Project $project){

        $oldBeforeImg = $project->beforeImage;
        $oldAfterImg =  $project->afterImage;


        if($oldBeforeImg){
            $oldBeforeImg->delete();
            File::delete($oldBeforeImg->path);
        }

        if ($oldAfterImg){
            $oldAfterImg->delete();
            File::delete($oldAfterImg->path);
        }

        $project->delete();

        return redirect()->route('admin.projects.index')->with('deleted' , 'before&after project images deleted successfully!!');
    }
}
