<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Message;

class MessageController extends Controller
{
    public function index(){
         $messages = Message::orderBy('message.created_at', 'desc')->get();
        return view('dashboard.messages.index', compact('messages'));
    }


    public function show(Message $message){
        return view('dashboard.messages.show', compact('message'));
    }

    public function destroy(Message $message){
        $message->delete();
        return redirect()->route('admin.message.index');
    }
}
