

<?php $__env->startSection('title'); ?>
    sliders
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="content-header">
        <h1>
            slider
            <small>All Sliders</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo e(adminUrl('/')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo e(route('admin.slider.index')); ?>">Sliders</a></li>
            <li class="active">show</li>
        </ol>
    </section>

    <div class="" style="width:95%; margin: auto; padding:20px;">
        <?php if(session()->has('created')): ?>
            <div class="alert alert-success" style="" role="alert">
                <?php echo e(session()->get('created')); ?>

            </div>
        <?php endif; ?>

        <?php if(session()->has('updated')): ?>
            <div class="alert alert-success" style="" role="alert">
                <?php echo e(session()->get('updated')); ?>

            </div>
        <?php endif; ?>

        <?php if(session()->has('deleted')): ?>
            <div class="alert alert-danger" role="alert">
                <?php echo e(session()->get('deleted')); ?>

            </div>
        <?php endif; ?>
    </div>

    <section class="content">
        <div class="row">
            <!-- left column -->
            <div class="col-md-12">

                <div class="box box-primary" style="padding: 15px">
                    <div class="box-header with-border">
                        <h3 class="box-title">Sliders</h3>
                                                <a href="<?php echo e(route('admin.slider.create')); ?>"
                                                   class="btn btn-primary pull-right"><i class="fa fa-plus"></i> Add New Slider </a>
                    </div>
                    <!-- /.box-header -->
                    <!-- form start -->
                    <div id="example1_wrapper" class="dataTables_wrapper form-inline dt-bootstrap">
                        <div class="row">
                            <div class="col-sm-12">
                                <table id="example1" class="table table-bordered table-striped show-edit-category-table">
                                    <thead>
                                    <tr>
                                        <th>Id</th>
                                        <?php if(!Request::url() == route('admin.slider.index')): ?>
                                        <th>Image</th>
                                        <?php endif; ?>
                                        <th>Title</th>
                                        <th>Created by</th>
                                        <th>Created at</th>
                                        <th>Updated at</th>
                                        <th>Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr role="row" class="even">
                                            <td class="sorting_1"><?php echo e($slider->id); ?></td>
                                            <?php if(!Request::url() == route('admin.slider.index')): ?>
                                            <td><img src="<?php echo e(asset($slider->image->path)); ?>" style="width: 50px" alt="<?php echo e($slider->image->alt); ?>"> </td>
                                            <?php endif; ?>
                                            <td><?php echo e($slider->slider_en->title); ?></td>
                                            <td><?php echo e($slider->user->name); ?></td>
                                            <td><?php echo e($slider->created_at->format('D M Y')); ?></td>
                                            <td><?php echo e($slider->updated_at->format('D M Y')); ?></td>
                                            <td>
                                                <a href="<?php echo e($slider->slideEdit()); ?>" class="" style="font-size: 20px"><i class="fa fa-pencil-square-o"></i> </a>
                                                <a href="<?php echo e($slider->createSubSlider()); ?>" class="" style="font-size: 20px"><i class="fa fa-plus" title="Add Mini Slider to this slider"></i> </a>
                                                <a href="<?php echo e($slider->show_sub()); ?>" class="" style="font-size: 20px"><i class="fa fa-eye" title="Show Sub-Services"></i> </a>
                                                <button type="button" class="" data-toggle="modal" data-target="<?php echo e('#delete'.$slider->id); ?>" style="font-size: 20px">
                                                    <i class="fa fa-trash"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tbody>
                                </table>

                            </div>
                        </div>
                    </div>

                    <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="modal modal-danger fade" id="<?php echo e('delete'.$slider->id); ?>">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">×</span></button>
                                        <h4 class="modal-title">Delete Slide</h4>
                                    </div>
                                    <div class="modal-body">
                                        <p>Are You Sure You Want To Delete Slide <strong><?php echo e($slider->slider_en->title); ?></strong></p>
                                    </div>
                                    <div class="modal-footer">
                                        <form action="<?php echo e($slider->slideDelete()); ?>" method="post">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <div class="d-flex flex-row">
                                                <button type="button" class="btn btn-outline-danger" data-dismiss="modal" style="margin-right: 5px">
                                                    cancel
                                                </button>
                                                <button type="submit" class="btn btn-danger">
                                                    Delete
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                                <!-- /.modal-content -->
                            </div>
                            <!-- /.modal-dialog -->
                        </div>
                        <!-- /.modal -->
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('dashboard.layouts.layouts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /mnt/d/php/laravel/vertex/resources/views/dashboard/slider/index.blade.php ENDPATH**/ ?>