@extends('dashboard.layouts.layouts')

@section('title')
    create service
@endsection
@section('customizedScript')
    <script>
        $(function(){
            CKEDITOR.replace("");
            CKEDITOR.replace("");

        })
    </script>
@endsection
@section('content')
    <section class="content-header">
        <h1>
            Album
            <small>Update Album</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="{{adminUrl('/')}}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="">Album</a></li>
            <li class="active">Update Album</li>
        </ol>
    </section>
    <section class="content">
        @include('dashboard.layouts.messages')
        <form role="form" action="{{$album->showImages()}}" enctype="multipart/form-data" method="post">
            @csrf
            @method('patch')
            <div class="row">
                <!-- English Side -->
                <div class="col-md-6">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Update Album Info</h3>
                        </div>
                        <!-- /.box-header -->
                        <!-- form start -->
                        <div class="box-body">
                            <div class="form-group">

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1">Album Name</label>
                                    <input type="text" class="form-control" name="title_en" id="exampleInputEmail1" placeholder="Enter Client Name" value="{{$album->album_en->title}}">
                                    <p class="help-block">Enter Name of Album</p>
                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1">Album Description</label>
                                    <input type="text" class="form-control" name="description_en" id="exampleInputEmail1" placeholder="Enter Album Description" value="{{$album->album_en->description}}">
                                    <p class="help-block">Enter Description of Album</p>
                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1"> Album Type</label>
                                    <select name="type" id="admin_type" class="form-control">
                                        <option value="0">Choose Album Type</option>
                                        <option value="img" {{$album->type == 'img' ? 'selected' : ''}}>Images</option>
{{--                                        <option value="vid" {{$album->type == 'vid' ? 'selected' : ''}}>Videos</option>--}}
                                    </select>
                                    <p class="help-block"> Choose type of album </p>
                                </div>
                                {{--<input type="hidden"name="type" value="1">--}}

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1"> Image</label>
                                    <input type="file" class="form-control" name="image_id" id="exampleInputEmail1" placeholder="Enter button text">
                                    <p class="help-block"> Upload Album Thumb Logo </p>
                                </div>
                            </div>
                        </div>
                        <div class="box-footer">
                            <div class="col-lg-12">
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Arabic Side -->
                <div class="col-md-6 arab_dir">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">أضف بيانات الألبوم</h3>
                        </div>
                        <!-- .box-header -->
                        <!-- form start -->
                        <div class="box-body">
                            <div class="form-group">

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1">اسم الألبوم</label>
                                    <input type="text" class="form-control" name="title_ar" id="exampleInputEmail1" placeholder="ادخل اسم العميل" value="{{$album->album_ar->title}}">
                                    <p class="help-block">أدخل اسم الألبوم</p>
                                </div>

                                <div class="col-lg-12">
                                    <label for="exampleInputEmail1">وصف الألبوم</label>
                                    <input type="text" class="form-control" name="description_ar" id="exampleInputEmail1" placeholder="ادخل وصف الألبوم" value="{{$album->album_ar->description}}">
                                    <p class="help-block">أدخل وصف الألبوم</p>
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </section>




@endsection