<?php

namespace App;

use App\Models\Slider;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    //eloquent relationship start

    public function roles(){
        return $this->belongsToMany('App\Role' , 'roles_users'
            , 'user_id', 'role_id');
    }

    public function sliders(){
        return $this->hasMany(Slider::class , 'user_id' , 'id');
    }
}



