<?php

namespace App\Providers;

use App\Http\View\Composers\AboutComposer;
use App\Http\View\Composers\AlbumComposer;
use App\Http\View\Composers\ContactComposer;
use App\Http\View\Composers\DashboardComposer;
use App\Http\View\Composers\ServiceComposer;
use App\Http\View\Composers\SettingComposer;
use App\Http\View\Composers\WebsiteComposer;
use App\Models\Setting;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
            View::composer([
            'website.index' ,
            'website.layouts.map',
            'website.layouts.header',
           'website.layouts.footer',
            'website.layouts.contact_form',
                'website.contact',
                'dashboard.setting.maintenance'
        ], WebsiteComposer::class);

            View::composer([
                'dashboard.layouts.sideMenu',
            ], DashboardComposer::class);

    }
}
