<?php

namespace App\Models;

use App\Models\Resource\Image;
use Illuminate\Database\Eloquent\Model;

class Blog extends Model
{
    protected $table = 'blogs';

    public function getRouteKeyName()
    {
        return 'url';
    }


    protected $fillable = ['url' , 'image_id'];
    /*<-====== Eloquent=relationships ======->*/

    public function blog_en()
    {

        return $this->hasOne(\App\Models\English\Blog::class , 'blog_id' , 'id');
    }

    public function blog_ar()
    {

        return $this->hasOne(\App\Models\Arabic\Blog::class , 'blog_id' , 'id');
    }

    public function image()
    {
//        return $this->hasOne(Image::class , 'id' , 'image_id');
        return $this->belongsTo(Image::class , 'image_id' , 'id');
    }


    public function images()
    {
        return $this->belongsToMany(Image::class , 'blogs_images' , 'blog_id' , 'image_id');
    }

    /*<-====== end=Eloquent=relationships ======->*/

    /*<-============== rout=functions =================->*/

    public function blogEdit(){
        return route('admin.blog.edit' , $this->url);
    }

    public function showImages(){
        return route('admin.blog.show' , $this->url);
    }

    public function blogUpdate(){
        return route('admin.blog.update' , $this->url);
    }

    public function blogDelete(){
        return route('admin.blog.destroy' , $this->url);
    }

    public function showBlog(){
        return route('show_blog' , $this->url);
    }
    /*<-============end= rout=functions ===============->*/
}
