<?php


namespace App\Http\View\Composers;


use App\Models\About;
use App\Models\Album;
use App\Models\Comment;
use App\Models\Contact;
use App\Models\Project;
use App\Models\Service;
use App\Models\Setting;
use App\Models\Blog;
use Illuminate\View\View;

class WebsiteComposer
{
    public function compose(View $view){
        /*<=================================>*/
        $setting = Setting::first()->load('headerLogo');
        /*<=================================>*/
        $services = Service::orderBy('services.created_at', 'desc')->with('services_'.currentLang() , 'image')->get();
        /*<=================================>*/
        $contact = Contact::first();
        /*<=================================>*/
        $albums = Album::orderBy('albums.created_at' , 'desc')->with('album_'.currentLang() , 'image')->get() ;
        /*<=================================>*/
        $about = About::first()->load('about_'.currentLang() , 'vision_image' , 'mission_image');
        /*<=================================>*/
        $blogs = Blog::orderBy('blogs.created_at', 'desc')->with('blog_'.currentLang() , 'image' , 'images')->get();
        /*<=================================>*/
        $projects = Project::orderBy('projects.created_at' , 'desc')->with('beforeImage' , 'afterImage')->get();
        /*<=================================>*/
        $comments = Comment::orderBy('comments.created_at' , 'desc')->with('comment_'.currentLang() , 'image')->get();
        /*<=================================>*/


        $view->with('setting' , $setting);
        $view->with('services' , $services);
        $view->with('contact' , $contact);
        $view->with('albums' , $albums );
        $view->with('about' , $about );
        $view->with('blogs' , $blogs);
        $view->with('projects' , $projects);
        $view->with('comments' , $comments);
    }
}