<?php


namespace App\Http\View\Composers;

use App\Models\About;
use App\Models\Contact;
use App\Models\Setting;
use Illuminate\View\View;

class DashboardComposer
{
   public function compose(View $view){
       /*<=================================>*/
       $setting = Setting::first()->load('headerLogo');
       /*<=================================>*/
       $contact = Contact::first();
       /*<=================================>*/
       $about = About::first()->load('about_'.currentLang());
       /*<=================================>*/

       $view->with('setting' , $setting);
       $view->with('contact' , $contact);
       $view->with('about' , $about );
   }
}