<?php

namespace App\Http\Controllers;


use App\Mail\ContactMail;
use App\Models\Album;
use App\Models\Message;
use Illuminate\Http\Request;
use App\Models\Slider;
use App\Models\About;
use App\Models\Service;
use App\Models\Contact;
use App\Models\Blog;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Mail;

class WebsiteController extends Controller
{
    public function index(){
        $mainSlider = Slider::where('slug' , 'main_slider')->first();
        $mainSlider = $mainSlider->childSlider()->get()->load('slider_en' , 'slider_ar' , 'image');

        $clientSlider = Slider::where('slug' , 'clients')->first();
        $clientSlider = $clientSlider->childSlider()->get()->load('slider_en' , 'slider_ar' , 'image');



        $blogs = Blog::with('blog_en' , 'blog_ar')->get();
        return view('website.index' , compact('mainSlider' , 'clientSlider' , 'blogs'));
    }

    public function about(){
        $about = About::first();
        return view('website.about' , compact('about'));
    }

    public function contact(){
        return view('website.contact');
    }

    public function albums(){
        $albums = Album::orderBy('albums.created_at' , 'desc')->with('album_'.currentLang() , 'image')->paginate(6) ;
        return view('website.albums.index' , compact('albums'));
    }

    public function gallery($slug){

        $album = Album::where('url' , $slug)->first()->load('images');
      return view('website.albums.show' , compact('album'));
    }


//    public function services(){
//        return view('website.services');
//    }

    public function show_service(Service $slug){
        $about = About::first()->load('about_image' , 'features_image' , 'about_'.currentLang());
        $services = Service::orderBy('services.created_at', 'desc')->with('services_'.currentLang())->get();
        $service = $slug->load('services_'.currentLang() , 'images');
        return view('website.services.show' , compact('service' , 'services' , 'about'));
    }

    public function blogs(){
        $blogs = Blog::orderBy('blogs.created_at', 'desc')->with('blog_'.currentLang() , 'image')->paginate(6);
        return view('website.blogs.index' , compact('blogs'));
    }

    public function show_blog(Blog $slug){
      $blog = $slug->load('blog_'.currentLang() , 'image');
      $blogs = Blog::orderBy('blogs.created_at', 'desc')->with('blog_'.currentLang() , 'image')->get();
      return view('website.blogs.show', compact('blog' , 'blogs'));
    }

    public  function contactMessage(Request $request){
        $request->validate([
            'name' => 'required',
            'email' => 'required|email',
            'phone' => 'required',
            'message' => 'required'
        ]);
        $email = Contact::first();
        $data = [
            'fullname' => $request['name'],
            'email' => $request['email'] ,
            'phone' => $request['phone'] ,
            'subject' => $request['subject'],
            'message' => $request['message']
        ];
        Message::create($data);
        Mail::to($email->email)->send(new ContactMail($data));
        return redirect()->back()->with('success' , 'thanks for contacting us!');
    }
}
