<?php

namespace App\Http\Controllers;

use App\Mail\ContactMail;
use App\Models\Contact;
use App\Models\Message;
use Illuminate\Http\Request;
use App\Models\Setting;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Session;
class SettingController extends Controller
{
    public function active(){
        $active = Setting::first();
        if($active->active == 0) {
            return view('dashboard.setting.maintenance');
        }else{
            return redirect('/');
        }
    }

    public function set_lang($lang){
        Session::put('lang' , $lang);
        return redirect()->back();
    }

    public function contact(Request $request){
        $request->validate([
            'name' => 'required',
            'email' => 'required|email',
            'phone' => 'required',
            'message' => 'required'
        ]);
        $email = Contact::first();
        $data = [
            'fullname' => $request['name'],
            'email' => $request['email'] ,
            'phone' => $request['phone'] ,
            'subject' => $request['subject'],
            'message' => $request['message']
        ];
        Message::create($data);
        Mail::to($email->email)->send(new ContactMail($data));
        return redirect()->back()->with('success' , 'thanks for contacting us!');
    }
}
