<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Models\Resource\Image;
use Illuminate\Http\Request;
use App\Models\Slider;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;

class SliderController extends Controller
{
    public function index(){
        $sliders = Slider::where('parent_slider_id', null)->with('slider_en', 'slider_ar')->get();
        return view('dashboard.slider.index',compact('sliders'));
    }

    public function show(Slider $slider){
        $sliders = $slider->childSlider()->with('slider_en', 'slider_ar')->get();
        return view('dashboard.slider.subslider.show' , compact('sliders'));
    }

    public function create(){

        return view('dashboard.slider.create');
    }


    public function store( Request $request){

        if($request['parent']){
            $request->validate([
                'title_en' => 'max:191',
                'title_ar' => 'max:191',
                'description_en' => 'max:1000',
                'description_ar' => 'max:1000',
                'alt' => 'max:50',
                'image_id' => 'required|mimes:jpg,jpeg,bmp,png|max:10240'
            ]);
        }else{
            $request->validate([
                'title_en' => 'required|max:191',
                'title_ar' => 'max:191',
                'alt' => 'max:50',
                'description_en' => 'max:1000',
                'description_ar' => 'max:1000',
            ]);
        }

        /*-----upload-&-create-image---*/
        if ($uploadedFile = $request->file('image_id')) {
            $fileName = time() . $uploadedFile->getClientOriginalName();
            $uploadedFile->move('dashboardImages/images', $fileName);
            $filePath = 'dashboardImages/images/' . $fileName;
            $img = new Image();
            $img->path = $filePath ;
            $img->name = $fileName;
            $img->alt= $request['alt'];
            $img->save();
        }
        /*----end-upload-&-create-image---*/



        /*<===========initialise=service=object===========>*/
        $slider = new Slider();
        $slider->slug = str_slug($request['title_en'] , '_');
        /*<==========end=initialise=service=object===========>*/

        /*<=================add=parent=slider=if=it=exists==================>*/
        if($request['parent']){
            if (Slider::find($request['parent']) ){
                $slider->parent_slider_id = $request['parent'];
            }else{
                return redirect()->route('admin.slider.index')->with('deleted' , 'there is no parent slider with that id!!');
            }
        }
        /*<===========end=add=parent=slider=if=it=exists===================>*/

        /*----create-slider-&-add-image-id------*/
        if($request->hasFile('image_id')) {
                $slider->image_id = $img->id;
        }


        $slider->btn_url = $request['url'] ;


        $slider->user_id = Auth::user()->id ;

        $slider->save();
        /*---end-create-slider-&-add-image-id---*/


        /*----create-localization-for-slider-------*/
        $slider->slider_en()->create([
            'title' => $request['title_en'] ,
            'description' => $request['description_en'],
            'btn' => $request['button_en']
        ]);

        $slider->slider_ar()->create([
            'title' => $request['title_ar'],
            'description' => $request['description_ar'],
            'btn' => $request['button_ar']
        ]);

        /*--end-create-localization-for-slider-----*/

        return redirect()->route('admin.slider.index')->with('created' , 'slider created successfully!!');
    }

    public function edit(Slider $slider){
        $slider->load('slider_en' , 'slider_ar');
        return view('dashboard.slider.edit' , compact('slider'));
    }

    public function update(Slider $slider , Request $request){

        if($slider->parent_slider_id){
            $request->validate([
                'title_en' => 'max:191',
                'title_ar' => 'max:191',
                'description_en' => 'max:1000',
                'description_ar' => 'max:1000',
                'alt' => 'max:50',
                'image_id' => 'mimes:jpg,jpeg,bmp,png|max:10240'
            ]);
        }else{
            $request->validate([
                'title_en' => 'required|max:191',
                'title_ar' => 'max:191',
                'alt' => 'max:50',
                'description_en' => 'max:1000',
                'description_ar' => 'max:1000',
            ]);
        }

        if($request->hasFile('image_id')){
            $oldImage = $slider->image;
        }


        /*-----upload-&-create-image---*/
        if ($uploadedFile = $request->file('image_id')) {
            $fileName = time() . $uploadedFile->getClientOriginalName();
            $uploadedFile->move('dashboardImages/images', $fileName);
            $filePath = 'dashboardImages/images/' . $fileName;
            $img = new Image();
            $img->path = $filePath ;
            $img->name = $fileName;
            $img->alt= $request['alt'];
            $img->save();
        }
        /*----end-upload-&-create-image---*/

        /*----create-slider-&-add-image-id------*/
        if($request->hasFile('image_id')) {
            $slider->image_id = $img->id;
        }

        $slider->btn_url = $request['url'];
        $slider->slug = str_slug($request['title_en'] , '_');

        $slider->update();
        /*---end-create-slider-&-add-image-id---*/

        /*----create-localization-for-slider-------*/
        $slider->slider_en()->update([
            'slide_id' => $slider->id,
            'title' => $request['title_en'],
            'description' => $request['description_en'],
            'btn' => $request['button_en']
        ]);

        $slider->slider_ar()->update([
            'slide_id' => $slider->id,
            'title' => $request['title_ar'],
            'description' => $request['description_ar'],
            'btn' => $request['button_ar']
        ]);

        /*--end-create-localization-for-slider-----*/

        if($request->hasFile('image_id') && $oldImage){
                $oldImage->delete();
                File::delete($oldImage->path);
        }
        return redirect()->route('admin.slider.index')->with('updated' , 'slider updated successfully!!');
    }

    public function destroy(Slider $slider){

        $oldImage = $slider->image;

        /**/
        if($slider->childSlider){
            foreach ($slider->childSlider as $miniSlider){
                $oldMiniImg = $miniSlider->image;

                $miniSlider->delete();

                if($oldMiniImg){
                    $oldMiniImg->delete();
                    File::delete($oldMiniImg->path);
                }
            }
        }
        /**/
        $slider->delete();

        if($oldImage){
            $oldImage->delete();
            File::delete($oldImage->path);
        }
        if($slider->parent_slider_id){
            return redirect()->route('admin.slider.show' , $slider->parent_slider_id )->with('deleted', 'slider deleted successfully!!');
        }

        return redirect()->route('admin.slider.index')->with('deleted', 'parent slider deleted successfully!!');
    }
}
