<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Models\Service;
use App\Models\Resource\Image;
use Illuminate\Contracts\View\Factory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;
use Illuminate\View\View;
use Illuminate\Http\Response;

class ServiceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return Factory|View
     */
    public function index()
    {
        $services = Service::orderBy('services.created_at' , 'desc')->with('services_' . currentLang() , 'image' , 'icon')->get();
        return view('dashboard.service.index' )->with('services',$services);
    }

    public function sub_show(Service $service)
    {
        $subservices = $service->childService()->with('services_en' , 'image' , 'icon')->orderBy('services.created_at' , 'desc')->get();
        return view('dashboard.service.subservice.show' , compact('subservices'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Factory|View
     */
    public function create()
    {
        return view('dashboard.service.create');
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param Request $request
     * @param Image $image
     * @param Service $service
     * @return void
     */
    public function store(Request $request )
    {

        /*<==================service=validation==============================>*/
        $request->validate([
            'title_en' => 'required|regex:/(^[a-zA-Z ]*$)/|max:191|unique:mysql_en.services,title',
            'title_ar' => 'max:191',
            'url' => 'unique:services',
            'description_en' => 'required',
            'image' => 'required|mimes:jpg,jpeg,bmp,png|max:10240',
            'images' => 'max:6',
            'images.*' => 'mimes:jpg,jpeg,bmp,png|max:10240'
        ]);
        /*<===============end=service=validation==============================>*/


        /*=======================upload=image========================*/
        if ($request->hasFile('image')) {
            $uploadedFile = $request->file('image');
            $fileName = time() . $uploadedFile->getClientOriginalName();
            $uploadedFile->move('dashboardImages/images', $fileName);
            $filePath = 'dashboardImages/images/' . $fileName;
            $img = new Image();
            $img->path = $filePath ;
            $img->name = $fileName;
            $img->alt= 'this is an image';
            $img->save();
        }

        /*======================end=upload=image========================*/

        /*======================upload=images========================*/
        $imageIds = [];
        if ($request->hasFile('images')) {
            $uploadedFile = $request->file('images');
            foreach ($uploadedFile as $file) {

                $fileName = time() . $file->getClientOriginalName();
                $file->move('dashboardImages/album', $fileName);
                $filePath = 'dashboardImages/album/' . $fileName;

                $imgs = new Image();
                $imgs->path = $filePath ;
                $imgs->name = $fileName;
                $imgs->alt= 'this is an image';
                $imgs->save();
                array_push($imageIds , $imgs->id );

            }
        }

        /*======================end=upload=images========================*/



        /*<===========initialise=service=object===========>*/
        $service = new Service();
        /*<==========end=initialise=service=object===========>*/


        /*<=================create=sub=service=if=parent=id=exists==========>*/
        if ($request['parent_service_id']){
            $service->parent_service_id = $request['parent_service_id'];
        }
        /*<=============end=create=sub=service=if=parent=id=exists==========>*/


        /*<===========add=sub=service=unique=url==============>*/
        if ($request['url']){
            $request->validate(['url' => 'regex:/(^[a-zA-Z- ]*$)/']);
            $service->url = Str::slug($request['url'] , '-');
        }

        if(empty($request['url'])){
            $service->url = Str::slug($request['title_en'] , '-');
        }
        /*<=======end=add=sub=service=unique=url==============>*/

        /*<==========add=files=to=service==============>*/
//        if ($request->hasFile('icon')){
//            $service->icon_id = $icon->id;
//        }

        if ($uploadedFile = $request->file('image')){
            $service->image_id = $img->id;
        }

        /*<===========saving=service=data===========>*/
        $service->save();
        /*<===========end=saving=service=data===========>*/

        if ($uploadedFile = $request->file('images')){
            $service->images()->attach($imageIds);
        }
        /*<=========end=add=files=to=service==============>*/



        /*<==========adding=localization=to=service==============>*/
        $service->services_en()->create([
            'title' => $request['title_en'] ,
            'sub_title' => $request['sub_title_en'],
            'description' => $request['description_en']
        ]);

        $service->services_ar()->create([
            'title' => $request['title_ar'] ,
            'sub_title' => $request['sub_title_ar'],
            'description' => $request['description_ar']
        ]);

        /*<==========adding=localization=to=service==============>*/

        if ($request['parent_service_id']){
            return redirect()->route('admin.services.index')->with('created', 'sub service has been created successfully!');
        }else{
            return redirect()->route('admin.services.index')->with('created', 'service has been created successfully!');
        }

    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Service $service)
    {
        $images = $service->images()->get();
        return view('dashboard.service.images.show' , compact('images'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  Service  $service
     * @return \Illuminate\Http\Response
     */
    public function edit(Service  $service)
    {
        $service->load('services_en' , 'services_en' , 'image' , 'icon')->get();
        return  view('dashboard.service.edit', compact('service'));
    }



    /**
     * Update the specified resource in storage.
     *
     * @param Request $request
     * @param  int  $id
     * @param  Service $service
     * @param Image $image
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,Service $service)
    {

        $request->validate([
            'title_en' => 'required|regex:/(^[a-zA-Z ]*$)/|max:191|unique:mysql_en.services,title,'.$service->services_en->id ,
            'title_ar' => 'max:191',
            'url' => 'required|regex:/(^[a-zA-Z-]*$)/|unique:services,url,'.$service->id ,
            'description_en' => 'required',
            'image' => 'mimes:jpg,jpeg,bmp,png|max:10240',
            'images' => 'max:6',
            'images.*' => 'mimes:jpg,jpeg,bmp,png|max:10240'
        ]);

        /*----------get-old-image&images-ids-----------*/
        if ($request->hasFile('image')) {
            $oldImg = $service->image ;
        }
        /*---------------------------------------------*/



        /*=======================upload=image========================*/
        if ($request->hasFile('image')) {
            $uploadedFile = $request->file('image');
            $fileName = time() . $uploadedFile->getClientOriginalName();
            $uploadedFile->move('dashboardImages/images', $fileName);
            $filePath = 'dashboardImages/images/' . $fileName;
            $img = new Image();
            $img->path = $filePath ;
            $img->name = $fileName;
            $img->alt= 'this is an image';
            $img->save();
        }

        /*======================end=upload=image========================*/

        /*======================upload=images========================*/
        $imageIds = [];
        if ($request->hasFile('images')) {
            $uploadedFile = $request->file('images');
            foreach ($uploadedFile as $file) {

                $fileName = time() . $file->getClientOriginalName();
                $file->move('dashboardImages/album', $fileName);
                $filePath = 'dashboardImages/album/' . $fileName;

                $imgs = new Image();
                $imgs->path = $filePath ;
                $imgs->name = $fileName;
                $imgs->alt= 'this is an image';
                $imgs->save();
                array_push($imageIds , $imgs->id );

            }
        }

        /*======================end=upload=images========================*/




        /*-------------------assign-new-id-to-service-----------------*/
        if($request->hasFile('image')){
            $service->image_id = $img->id;
        }


        if ($request['url']){
            $service->url = Str::slug($request['url'] , '-');
        }

        if(empty($request['url'])){
            $service->url = Str::slug($request['title_en'] , '-');
        }

        if($request->hasFile('images')){
            $service->images()->attach($imageIds);
        }
        /*---------------end-assign-new-id-to-service-----------------*/




        /*-------------------delete-image&images---------------------------*/
        if($request->hasFile('image') && $oldImg){
            /*------------delete-image----------------*/
              File::delete($oldImg->path);
              $oldImg->delete();
            /*----------end-delete-image----------------*/
        }



        $service->update();

        $service->services_en()->update([
            'service_id' => $service->id,
            'title' => $request['title_en'],
            'sub_title' => $request['sub_title_en'],
            'description' => $request['description_en']
        ]);

        $service->services_ar()->update([
            'service_id' => $service->id,
            'title' => $request['title_ar'],
            'sub_title' => $request['sub_title_ar'],
            'description' => $request['description_ar']
        ]);

        if ($service->parent_service_id){
        return redirect()->route('admin.services.index')->with('updated', 'sub service has been updated successfully!');
        }
        return redirect()->route('admin.services.index')->with('updated', 'service has been updated successfully!');
    }

    public function sub_update($service)
    {
//        return view('' , compact('service'));
    }
    /**
     * Remove the specified resource from storage.
     * @param Service $service
     * @param  Image $image
     * @return \Illuminate\Http\Response
     */
    public function destroy(Service $service )
    {
        /*<================old-image&images-ids=====================>*/
        if($service->image){
            $oldImage = $service->image;
        }

        if ($service->icon){
            $oldIcon = $service->icon;
        }

        if ($service->images){
            $oldImages = $service->images;
        }
        /*<===============end=old=image&images=ids=====================>*/

        /*<===============sub=services=delete=====================>*/
        if ($service->childService){
             foreach ($service->childService as $childService){
                 /*============================================*/
                 if ($childService->image){
                 $childService->image->delete();
                 File::delete($childService->image->path);
                 }
                 /*============================================*/

                 /*============================================*/
                 if ($childService->icon){
                 $childService->icon->delete();
                 File::delete($childService->icon->path);
                 }
                 /*============================================*/

                 /*===============================================*/
                 if ($childService->images){
                   foreach($childService->images as $childImage){
                       $childService->images()->detach($childImage->id);
                       $childImage->delete();
                       File::delete($childImage->path);
                   }
                 }
                 $childService->delete();
            }
        }
        /*<=============end=sub=services=delete=====================>*/


           $service->delete();


        // delete single image.
         if ($service->image && $oldImage){
             $oldImage->delete();
        File::delete($oldImage->path);
        }
        /////////////////////////

        // delete single icon.
        if ($service->icon && $oldIcon){
            $oldIcon->delete();
           File::delete($oldIcon->path);
        }
        /////////////////////////

        //delete multi images//
        if ($service->images && $oldImages){
        foreach($oldImages as $imageId){
             $service->images()->detach($imageId->id);
            $imageId->delete();
            File::delete($imageId->path);
        }
        }
        ////////////////////////

        return redirect()->back()->with('deleted' , 'service has been deleted successfully!');

    }


}
