<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Models\About;
use App\Models\Resource\Image;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class AboutController extends Controller
{
  public function edit(About $about){
     $about->load('about_en','about_ar')->get();
      return view('dashboard.about.edit' , compact('about'));
  }

  public function update(Request $request , About $about){
      $this->validateAbout($request);
      /*----------------old-images-ids------------------------*/
      if($request->hasFile('about_image_id')) {
         $oldAboutImg = $about->about_image;
      }

      if($request->hasFile('vision_image_id')) {
          $oldVisionImg = $about->vision_image ;
      }

      if($request->hasFile('mission_image_id')) {
          $oldMissionImg = $about->mission_image ;
      }


      if($request->hasFile('values_image_id')) {
          $oldValuesImg = $about->values_image ;
      }

      if($request->hasFile('features_image_id')) {
          $oldFeaturesImg = $about->features_image ;
      }

      /*---------------end-old-images-ids----------------------*/



      /*------------------update-images---------------------------*/

       if($request->hasFile('about_image_id')){
           $about_img = $request->file('about_image_id');
           $about_img_name = time().$about_img->getClientOriginalName();
           $about_img->move('dashboardImages/images', $about_img_name);
           $about_img_path = 'dashboardImages/images/'.$about_img_name;

           $about_img_new = new Image();
           $about_img_new->path = $about_img_path;
           $about_img_new->name = $about_img_name;
           $about_img_new->save();
       }

      if($request->hasFile('vision_image_id')){
          $vision_img = $request->file('vision_image_id');
          $vision_img_name = time().$vision_img->getClientOriginalName();
          $vision_img->move('dashboardImages/images', $vision_img_name);
          $vision_img_path = 'dashboardImages/images/'.$vision_img_name;

          $vision_img_new = new Image();
          $vision_img_new->path = $vision_img_path;
          $vision_img_new->name = $vision_img_name;
          $vision_img_new->save();
      }

      if($request->hasFile('mission_image_id')){
          $mission_img = $request->file('mission_image_id');
          $mission_img_name = time().$mission_img->getClientOriginalName();
          $mission_img->move('dashboardImages/images', $mission_img_name);
          $mission_img_path = 'dashboardImages/images/'.$mission_img_name;

          $mission_img_new = new Image();
          $mission_img_new->path = $mission_img_path;
          $mission_img_new->name = $mission_img_name;
          $mission_img_new->save();
      }

      if($request->hasFile('features_image_id')){
          $features_img = $request->file('features_image_id');
          $features_img_name = time().$features_img->getClientOriginalName();
          $features_img->move('dashboardImages/images', $features_img_name);
          $features_img_path = 'dashboardImages/images/'.$features_img_name;

          $features_img_new = new Image();
          $features_img_new->path = $features_img_path;
          $features_img_new->name = $features_img_name;
          $features_img_new->save();
      }


      /*----------------end-update-images-------------------------*/



      /*-----------------assign-img-ids-to-about------------------*/
      if ($request->hasFile('about_image_id')) {
          $about->about_img = $about_img_new->id;
      }

      if ($request->hasFile('vision_image_id')) {
          $about->vision_img = $vision_img_new->id;
      }

      if ($request->hasFile('mission_image_id')) {
          $about->mission_img = $mission_img_new->id;
      }

      if ($request->hasFile('features_image_id')) {
          $about->features_img = $features_img_new->id;
      }

      /*--------------end-assign-img-ids-to-about------------------*/

      /*-==============update=website=videos======================-*/

//       $about->about_vid = $request['about_vid'];
//       $about->vision_vid = $request['vision_vid'];
      /*-==============update=website=videos======================-*/


      $about->update();

      $about->about_en()->update([
          'description' => $request['description_en'],
          'mission_text' => $request['mission_en'],
          'vision_text'  => $request['vision_en'],
          'values_text'  => $request['values_en'],
          'goals_text' => $request['goals_en'],
          'features_text' => $request['features_en']
      ]);

      $about->about_ar()->update([
          'description' => $request['description_ar'],
          'mission_text' => $request['mission_ar'],
          'vision_text'  => $request['vision_ar'],
          'values_text'  => $request['values_ar'],
          'goals_text' => $request['goals_ar'],
          'features_text' => $request['features_ar']
      ]);

      /*-------------------delete-images---------------------*/

      if($request->hasFile('about_image_id') && $oldAboutImg ) {
              $oldAboutImg->delete();
              File::delete($oldAboutImg->path);
      }

      if($request->hasFile('vision_image_id') ){
              $oldVisionImg->delete();
              File::delete($oldVisionImg->path);
      }

      if($request->hasFile('mission_image_id') && $oldMissionImg ){
              $oldMissionImg->delete();
              File::delete($oldMissionImg->path);
      }

      if ($request->hasFile('features_image_id') && $oldFeaturesImg) {
          $oldFeaturesImg->delete();
          File::delete($oldFeaturesImg->path);
      }

      /*-----------------end-delete-images--------------------*/

      return redirect()->route('admin.about.edit' , $about->id)->with('updated' , 'about website updated successfully!!');
  }

  public function validateAbout(Request $request){
     return $request->validate([
         'description_en' => 'required',
         'vision_en' => 'required',
         'mission_en' => 'required',
         'features_en' => 'required'
      ]);
  }


}
